/* SCE CONFIDENTIAL
* PlayStation(R)3 Programmer Tool Runtime Library 430.001
* Copyright (C) 2012 Sony Computer Entertainment Inc.
* All Rights Reserved.
*/

#ifndef _SCE_MUTEX_H
#define _SCE_MUTEX_H

namespace sce {
	namespace Toolkit{
		namespace NP{
			namespace Utilities {

	/// @brief
	/// Abstract class interface of a simple Mutual exclusion lock.
	///
	/// The class has no implementation and just defines the interface 
	/// which can be be implemented for specific platforms in other classes.
	class Mutex {
	public:
		/// @brief 
		/// Default constructor
		///
		/// Default constructor. Object must be inited after construction.
		Mutex() {}
		/// @brief 
		/// Default destructor
		///
		/// Default destructor. Object must be termed before destruction.
		virtual ~Mutex() {}
		/// @brief
		/// Abstract method to initialise object.
		///
		/// Abstract method to initialise object.
		/// @return Returns SUCCESS or a generic error value.
		virtual int init() = 0;
		/// @brief
		/// Abstract method to terminate object.
		///
		/// Abstract method to terminate object.
		/// @return Returns SUCCESS or a generic error value.
		virtual int term() = 0;


		/// @brief
		/// Abstract method to lock the object.
		///
		/// Abstract method to initialise object.
		/// @return Returns SUCCESS or a generic error value.
		virtual int lock() = 0;

		/// @brief
		/// Abstract method to unlock the object.
		///
		/// Abstract method to unlock the object.
		/// @return Returns SUCCESS or a generic error value.
		virtual int unlock() = 0;

		/// @brief
		/// Abstract method to try the lock of the object.
		///
		/// Abstract method to try the lock of the object.
		/// @return Returns SUCCESS or a generic error value.
		virtual int tryLock() = 0;

	};

			}//end Utilities
		}//end NP
	}//end Toolkit
}//end sce
#endif
